<?php
    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * Classe che definisce i Tag
    */
    class Tag {
        private $db;
        private $id;
        private $nome;
        private $tipo;
        private $posizione;
        private $dataCreazione;
        
        function __construct($db, $id) {
            $this->db = $db;
            $this->id = $id;
            $this->nome = "";
            $this->tipo = "";
            $this->posizione = 0;
            $this->dataCreazione = "";
        }
        
        function crea() {
            $dataCreazione = date("Y-m-d");
            $queryControlloTagEsistente ="SELECT * FROM geec_tag WHERE nome LIKE '$this->nome'";
            $ris = $this->db->eseguiQueryLettura($queryControlloTagEsistente);
            if($ris->num_rows == 0) {
                $query = "INSERT INTO geec_tag VALUES(NULL,'$this->nome','$this->tipo',$this->posizione,'$dataCreazione')";
                $this->id = $this->db->eseguiQueryCreazione($query);
                return $this->id;
            }
            else {
                return -1;
            }
        }

        function modifica() {
            $query = "UPDATE geec_tag SET nome='$this->nome', posizione = $this->posizione WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function associaAdArticolo($idArticolo) {
            $query = "INSERT INTO geecB_associazioniTagArticoli VALUES(NULL,$idArticolo,$this->id);";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_tag",$this->id);
            
            $this->db->eseguiQueryScrittura("DELETE FROM geecB_associazioniTagArticoli WHERE idTag = $this->id");
        }
        
        function getId() {
            return $this->id;
        }

        function getTipo() {
            return $this->tipo;
        }
        
        function getNome() {
            return $this->nome;
        }

        function getPosizione() {
            return $this->posizione;
        }
        
        function getDataCreazione() {
            return $this->dataCreazione;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setTipo($tipo) {
            $this->tipo = $tipo;
        }
        
        function setNome($nome) {
            $this->nome = $nome;
        }

        function setPosizione($posizione) {
            $this->posizione = $posizione;
        }
        
        function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }

    }
